import 'package:flutter/material.dart';
import 'package:remixicon_updated/remixicon_updated.dart';

import 'package:admin_desktop/presentation/styles/style.dart';

class CustomRefreshButton extends StatelessWidget {
  final VoidCallback onTap;
  const CustomRefreshButton({super.key, required this.onTap});

  @override
  Widget build(BuildContext context) {
    return GestureDetector(
      onTap: onTap,
      child: Container(
          decoration: BoxDecoration(
              color: Style.white,
              borderRadius: BorderRadius.circular(10)),
          padding: const EdgeInsets.all(10),
          child: const Icon(Remix.restart_line)),
    );
  }
}
